<?php /* var_dump($permission); */ ?>
<?php (empty($permission) ? redirect(base_url("error404")) : "");
?>
<?php if (!empty($this->app->is_can($permission, "view"))) { /* Can View */ ?>

    <style>
        .btn-xs {
            height: 22px;
            padding: 2px 5px;
            font-size: 12px;
            line-height: 1.5;
            /* If Placeholder of the input is moved up, rem/modify this. */
            border-radius: 3px;
        }

        .table td,
        .table th {

            font-size: 13px;
        }

        th.dt-center,
        td.dt-center {
            width: 5px;
            text-align: center;
        }

        th.dt-active,
        td.dt-active {
            width: 15px;
            text-align: center;
        }
    </style>

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->

    <div class="col-12 pt-3">
        <div class="table-responsive m-t-40">
            <table id="mTable" class="table table-bordered table-striped table-hover" style="width:100%">
                <thead>
                    <tr>
                        <th>Datetime</th>
                        <th>Username</th>
                        <th>IP(OS)</th>
                        <th>Device</th>
                        <th>Browser</th>
                        <th>Module</th>
                        <th class="IsActive IsNotSort text-center"><i class="fa fa-eye"></i></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>

    <div class="modal fade" id="viewModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">ดูรายละเอียด</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="control-label">Datetime</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="datetime" readonly autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Username</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="user_name" readonly autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">IP</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="ip" readonly autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">OS</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="os" readonly autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Device(browser)</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="device" readonly autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Module</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="page" readonly autocomplete="off">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Query</label>
                            <div class="controls">
                                <textarea class="form-control" id="query" class="p-3" rows="4" cols="80" readonly></textarea>
                            </div>
                        </div>
                        <div class=" form-group">
                            <label class="control-label">Remark</label>
                            <div class="controls">
                                <input type="text" class="form-control" id="remark" readonly autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="reset" class="btn btn-xs btn-default" data-dismiss="modal">ปิด</button>
                </div>
            </div>
        </div>
    </div>
    <!-- /.modal -->

    <!-- Custom styles for this page -->
    <link href="<?php echo base_url(); ?>vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    <!-- Bootstrap core JavaScript-->
    <script src="<?php echo base_url(); ?>vendor/jquery/jquery.min.js"></script>
    <!-- Page level plugins -->
    <script src="<?php echo base_url(); ?>vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo base_url(); ?>vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <script type="text/javascript">
        var mTable;
        ! function(window, document, $) {
            "use strict";
            mTable = $('#mTable').DataTable({
                "orderable": false,
                "autoWidth": false,
                "pageLength": 10,
                "processing": true,
                "stateSave": true,
                stateSaveCallback: function(settings, data) {
                    localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
                },
                stateLoadCallback: function(settings) {
                    return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
                },
                "language": {
                    "url": "<?php echo base_url() ?>vendor/datatables/th.json",
                    "headers": {
                        "Access-Control-Allow-Origin": "*"
                    },
                    searchPlaceholder: "<?php echo strip_tags(@$var->txt_search); ?>",
                },
                "ajax": "<?php echo base_url('sys/log/ajax_list'); ?>",
                "deferRender": true,
                "aLengthMenu": [
                    [10, 25, 50, 100],
                    [10, 25, 50, 100]
                ],
                "columns": [{
                        "data": "datetime"
                    },
                    {
                        "data": "user_name"
                    },
                    {
                        "data": {
                            "ip": "ip",
                            "os": "os"
                        },
                        render: function(data, type) {
                            return data.ip + "/" + data.os;
                        }
                    },
                    {
                        "data": "device"
                    },
                    {
                        "data": "browser"
                    },
                    {
                        "data": "page"
                    },
                    {
                        "data": {
                            "id": "id"
                        },
                        render: function(data, type) {
                            return '<button type="button" class="btn btn-info btn-xs btnView" data-id="' + data.id + '" title="ดูรายละเอียด" data-toggle="modal" data-backdrop="static" data-keyboard="false" data-target="#viewModal"><i class="fas fa-search"></i></button>';
                        }
                    }
                ],
                "columnDefs": [{
                        targets: '_all'
                    },
                    {
                        "width": "5px",
                        "targets": 0
                    },
                    {
                        "className": "dt-active",
                        "targets": "IsActive"
                    },
                    {
                        "orderable": false,
                        "className": "dt-center",
                        "targets": "IsNotSort"
                    }
                ],
            });

            $('#mTable tbody').on('click', 'tr td .btnView', function() {
                $.post("<?php echo base_url('sys/log/ajax_data'); ?>", {
                        id: $(this).data('id')
                    },
                    function(data) {
                        $('#datetime').val(data['datetime']);
                        $('#user_name').val(data['user_name']);
                        $('#ip').val(data['ip']);
                        $('#os').val(data['os']);
                        $('#device').val(data['device'] + "(" + data['browser'] + ")");
                        $('#page').val(data['page']);
                        $('#query').html(data['query']);
                        $('#remark').val(data['remark']);
                    }, "json");
            });

            setInterval(function() {
                $.post('<?php echo base_url('sys/log/timestamp'); ?>',
                    function(data) {
                        if (timestamp != data) {
                            timestamp = data;
                            mTable.ajax.reload();
                        }
                    });

            }, 12340);

        }(window, document, jQuery);
        $(document).ready(function() {

        });
    </script>
<?php
} /* Can View */ ?>